/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.ReflectiveFactoryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveFactoryReaderTest
extends TestCase {
    public void testIteratesOverFactoryMethods() {
        ReflectiveFactoryReader reader = new ReflectiveFactoryReader(SimpleSetOfMatchers.class);
        Iterator methods = reader.iterator();
        ReflectiveFactoryReaderTest.assertTrue((String)"Expected first method", (boolean)methods.hasNext());
        FactoryMethod firstMethod = (FactoryMethod)methods.next();
        ReflectiveFactoryReaderTest.assertEquals((String)"firstMethod", (String)firstMethod.getName());
        ReflectiveFactoryReaderTest.assertEquals((String)SimpleSetOfMatchers.class.getName().replace('$', '.'), (String)firstMethod.getMatcherClass());
        ReflectiveFactoryReaderTest.assertTrue((String)"Expected second method", (boolean)methods.hasNext());
        FactoryMethod secondMethod = (FactoryMethod)methods.next();
        ReflectiveFactoryReaderTest.assertEquals((String)"secondMethod", (String)secondMethod.getName());
        ReflectiveFactoryReaderTest.assertEquals((String)SimpleSetOfMatchers.class.getName().replace('$', '.'), (String)secondMethod.getMatcherClass());
        ReflectiveFactoryReaderTest.assertFalse((String)"Expected no more methods", (boolean)methods.hasNext());
    }

    public void testOnlyReadsPublicStaticAnnotatedMethodsThatReturnNonVoid() {
        ReflectiveFactoryReader reader = new ReflectiveFactoryReader(MatchersWithDodgySignatures.class);
        Iterator methods = reader.iterator();
        ReflectiveFactoryReaderTest.assertTrue((String)"Expected first method", (boolean)methods.hasNext());
        ReflectiveFactoryReaderTest.assertEquals((String)"goodMethod", (String)((FactoryMethod)methods.next()).getName());
        ReflectiveFactoryReaderTest.assertTrue((String)"Expected second method", (boolean)methods.hasNext());
        ReflectiveFactoryReaderTest.assertEquals((String)"anotherGoodMethod", (String)((FactoryMethod)methods.next()).getName());
        ReflectiveFactoryReaderTest.assertFalse((String)"Expected no more methods", (boolean)methods.hasNext());
    }

    public void testReadsFullyQualifiedGenericType() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(GenerifiedMatchers.class, "generifiedType");
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Comparator<java.lang.String>", (String)method.getGenerifiedType());
    }

    public void testReadsNullGenerifiedTypeIfNotPresent() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(GenerifiedMatchers.class, "noGenerifiedType");
        ReflectiveFactoryReaderTest.assertNull((Object)method.getGenerifiedType());
    }

    public void testReadsGenericsInGenericType() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(GenerifiedMatchers.class, "crazyType");
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Map<? extends java.util.Set<java.lang.Long>, org.hamcrest.Factory>", (String)method.getGenerifiedType());
    }

    public void testReadsParameterTypes() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(ParamterizedMatchers.class, "withParam");
        List params = method.getParameters();
        ReflectiveFactoryReaderTest.assertEquals((int)3, (int)params.size());
        ReflectiveFactoryReaderTest.assertEquals((String)"java.lang.String", (String)((FactoryMethod.Parameter)params.get(0)).getType());
        ReflectiveFactoryReaderTest.assertEquals((String)"int[]", (String)((FactoryMethod.Parameter)params.get(1)).getType());
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Collection<java.lang.Object>", (String)((FactoryMethod.Parameter)params.get(2)).getType());
    }

    public void testReadsArrayAndVarArgParameterTypes() {
        FactoryMethod arrayMethod = ReflectiveFactoryReaderTest.readMethod(ParamterizedMatchers.class, "withArray");
        ReflectiveFactoryReaderTest.assertEquals((String)"java.lang.String[]", (String)((FactoryMethod.Parameter)arrayMethod.getParameters().get(0)).getType());
        FactoryMethod varArgsMethod = ReflectiveFactoryReaderTest.readMethod(ParamterizedMatchers.class, "withVarArgs");
        ReflectiveFactoryReaderTest.assertEquals((String)"java.lang.String...", (String)((FactoryMethod.Parameter)varArgsMethod.getParameters().get(0)).getType());
    }

    public void testReadsGenerifiedParameterTypes() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(ParamterizedMatchers.class, "withGenerifiedParam");
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Collection<? extends java.lang.Comparable<java.lang.String>>", (String)((FactoryMethod.Parameter)method.getParameters().get(0)).getType());
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Set<java.lang.String[]>[]", (String)((FactoryMethod.Parameter)method.getParameters().get(1)).getType());
    }

    public void testCannotReadParameterNamesSoMakesThemUpInstead() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(ParamterizedMatchers.class, "withParam");
        List params = method.getParameters();
        ReflectiveFactoryReaderTest.assertEquals((String)"param1", (String)((FactoryMethod.Parameter)params.get(0)).getName());
        ReflectiveFactoryReaderTest.assertEquals((String)"param2", (String)((FactoryMethod.Parameter)params.get(1)).getName());
        ReflectiveFactoryReaderTest.assertEquals((String)"param3", (String)((FactoryMethod.Parameter)params.get(2)).getName());
    }

    public void testReadsExceptions() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(ExceptionalMatchers.class, "withExceptions");
        List exceptions = method.getExceptions();
        ReflectiveFactoryReaderTest.assertEquals((int)3, (int)exceptions.size());
        ReflectiveFactoryReaderTest.assertEquals((String)"java.lang.Error", (String)((String)exceptions.get(0)));
        ReflectiveFactoryReaderTest.assertEquals((String)"java.io.IOException", (String)((String)exceptions.get(1)));
        ReflectiveFactoryReaderTest.assertEquals((String)"java.lang.RuntimeException", (String)((String)exceptions.get(2)));
    }

    public void testCannotReadJavaDoc() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(WithJavaDoc.class, "documented");
        ReflectiveFactoryReaderTest.assertEquals(null, (String)method.getJavaDoc());
    }

    public void testReadsGenericTypeParameters() {
        FactoryMethod method = ReflectiveFactoryReaderTest.readMethod(G.class, "x");
        ReflectiveFactoryReaderTest.assertEquals((String)"T", (String)((String)method.getGenericTypeParameters().get(0)));
        ReflectiveFactoryReaderTest.assertEquals((String)"V extends java.util.List<java.lang.String> & java.lang.Comparable<java.lang.String>", (String)((String)method.getGenericTypeParameters().get(1)));
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Map<T, V[]>", (String)method.getGenerifiedType());
        ReflectiveFactoryReaderTest.assertEquals((String)"java.util.Set<T>", (String)((FactoryMethod.Parameter)method.getParameters().get(0)).getType());
        ReflectiveFactoryReaderTest.assertEquals((String)"V", (String)((FactoryMethod.Parameter)method.getParameters().get(1)).getType());
    }

    public void testCatchesSubclasses() {
        ReflectiveFactoryReaderTest.assertNotNull((Object)ReflectiveFactoryReaderTest.readMethod(SubclassOfMatcher.class, "subclassMethod"));
    }

    private static FactoryMethod readMethod(Class<?> cls, String methodName) {
        for (FactoryMethod method : new ReflectiveFactoryReader(cls)) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubclassOfMatcher {
        @Factory
        public static BaseMatcher<?> subclassMethod() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class G {
        @Factory
        public static <T, V extends List<String> & Comparable<String>> Matcher<Map<T, V[]>> x(Set<T> t, V v) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithJavaDoc {
        @Factory
        public static Matcher<String> documented() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExceptionalMatchers {
        @Factory
        public static Matcher<String> withExceptions() throws Error, IOException, RuntimeException {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParamterizedMatchers {
        @Factory
        public static Matcher<String> withParam(String someString, int[] numbers, Collection<Object> things) {
            return null;
        }

        @Factory
        public static Matcher<String> withArray(String[] array) {
            return null;
        }

        @Factory
        public static Matcher<String> withVarArgs(String ... things) {
            return null;
        }

        @Factory
        public static Matcher<String> withGenerifiedParam(Collection<? extends Comparable<String>> things, Set<String[]>[] x) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GenerifiedMatchers {
        @Factory
        public static Matcher<Comparator<String>> generifiedType() {
            return null;
        }

        @Factory
        public static Matcher noGenerifiedType() {
            return null;
        }

        @Factory
        public static Matcher<Map<? extends Set<Long>, Factory>> crazyType() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchersWithDodgySignatures {
        @Factory
        public Matcher<String> notStatic() {
            return null;
        }

        @Factory
        static Matcher<String> notPublic() {
            return null;
        }

        public static Matcher<String> noAnnotation() {
            return null;
        }

        @Factory
        public static Matcher<String> goodMethod() {
            return null;
        }

        @Factory
        public static String anotherGoodMethod() {
            return null;
        }

        @Factory
        public static void wrongReturnType() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleSetOfMatchers {
        @Factory
        public static Matcher<String> firstMethod() {
            return null;
        }

        @Factory
        public static Matcher<String> secondMethod() {
            return null;
        }
    }
}

